# Application Plugin: Hello World

This page describes how to create a custom application that is visible via the URL `/hello`.

## Activate the included plugin

A compiled version of the plugin is made available as `application.helloworld.sample.zip`. In order to test this plugin, you need to copy the plugin ZIP file into the plugins folder of your installation or upload the plugin using Drag & Drop in the Store application. Afterwards the server needs to be restarted. You can check if the plugin was loaded in the dialog Store application. If there are problems, then check the log file of the server for more details. The module will now be displayed on the start page of the server.

## Server Plugin

You can also write your own implementation of the interface `com.inet.plugin.ServerPlugin`. In the method `registerExtension` you must register your class. This can look like:

```java
public void registerExtension( ServerPluginManager spm ) {
    spm.register( PluginServlet.class, new HelloWorldPluginServlet() );
}
```

Please refer to the sample `com.inet.application.helloworld.HelloWorldServerPlugin` to see how this is done there.

## Build the plugin

The following steps need to be taken if changes are made to the plugin code.

The `plugin.properties` and server plugin class are preconfigured to be used without modifications. If the sample is the basis for a custom plugin or just needs some adaptions, please refer to the platform programming guide for detailed instructions.

### Collect the required jar files

In order to build this plugin the following jar files are required at minimum:

  * `inetcore.jar` (included in the `core` directory)
  * `jakarta.servlet-api.jar` (included in the `core` directory)

These files are part of the SDK but will also be loaded from our public maven server when using the packaged `build.gradle`.

### Build the plugin

The plugin must be compiled into a jar file that is named like the id of the plugin. In this example it is `application.helloworld.sample.jar`. It also must contain the compiled sources as well as required language resources and images.

The target plugin is a zip file, named `application.helloworld.sample.zip` in this example. It contains the compiled jar file and the `plugin.properties` which configure the custom plugin.

The provided `build.gradle` in the sample can be used to build the plugin as well as any other build system.

## Deploying

Copy the ZIP file of the plugin into the plugins directory of the server and restart it. If there are problems, then check the log file of the server for more details. The "Config" logger is used to log plugin registration issues.

